/*
 * Decompiled with CFR 0.152.
 */
package view;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import until.Color;

public class Menu {
    private String leftOption;
    private String rightOption;
    private String cancelOption = "\u53d6\u6d88";
    private String okOption = "\u786e\u5b9a";
    private String[] menuOptions;
    private int padding;
    private Font ft;
    private int width;
    private int height;
    public int menuHeight;
    public int submenuMaxWidth = 0;
    public int submenuMaxHeight = 0;
    public boolean isActive = false;
    public int select = 0;

    public Menu(GameCanvas canvas) {
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
    }

    public Menu(GameCanvas canvas, String leftOption, String rightOption, String[] menuOptions) {
        this.leftOption = leftOption;
        this.rightOption = rightOption;
        this.menuOptions = menuOptions;
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
    }

    public void drawMenu(GameCanvas canvas, Graphics graphics, String leftOption, String rightOption) {
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
        this.padding = 5;
        this.ft = Font.getFont((int)64, (int)1, (int)0);
        int fontHeight = this.ft.getHeight();
        this.menuHeight = fontHeight + 2 * this.padding;
        graphics.setColor(Color.cmdSelectTop);
        graphics.fillRect(0, this.height - this.menuHeight, this.width, this.menuHeight / 2 + 1);
        graphics.setColor(Color.cmdSelectBottom);
        graphics.fillRect(0, this.height - this.menuHeight / 2, this.width, this.menuHeight / 2);
        graphics.setFont(this.ft);
        graphics.setColor(Color.label);
        if (leftOption != null) {
            graphics.drawString(leftOption, this.padding, this.height - this.padding, 36);
        }
        if (rightOption != null) {
            graphics.drawString(rightOption, this.width - this.padding, this.height - this.padding, 40);
        }
    }

    public void drawSubMenu(Graphics graphics, int selectedOptionIndex) {
        this.padding = 6;
        this.ft = Font.getFont((int)64, (int)1, (int)0);
        int fontHeight = this.ft.getHeight();
        this.submenuMaxWidth = 0;
        this.submenuMaxHeight = 0;
        int currentWidth = 0;
        int i = 0;
        while (i < this.menuOptions.length) {
            currentWidth = this.ft.stringWidth(this.menuOptions[i]);
            if (currentWidth > this.submenuMaxWidth) {
                this.submenuMaxWidth = currentWidth;
            }
            this.submenuMaxHeight += fontHeight + this.padding;
            ++i;
        }
        this.submenuMaxWidth += 6 * this.padding;
        int sub_padding = 3;
        int sub_margin_left = 2;
        int sub_margin_bottom = 2;
        int submenuFrameMaxWidth = this.submenuMaxWidth + 2 * sub_padding;
        int submenuFrameMaxHeight = this.submenuMaxHeight + 2 * sub_padding;
        graphics.setColor(Color.menuFrame);
        graphics.drawRoundRect(sub_margin_left, this.height - this.menuHeight - submenuFrameMaxHeight - sub_margin_bottom, submenuFrameMaxWidth, submenuFrameMaxHeight, 5, 5);
        graphics.setColor(Color.menuBg);
        graphics.fillRoundRect(sub_margin_left + 1, this.height - this.menuHeight - submenuFrameMaxHeight - sub_margin_bottom + 1, submenuFrameMaxWidth - 1, submenuFrameMaxHeight - 1, 5, 5);
        graphics.setFont(this.ft);
        int menuOptionX = sub_margin_left + sub_padding + this.padding;
        int menuOptionY = this.height - this.menuHeight - this.submenuMaxHeight - sub_margin_bottom - sub_padding + this.padding / 2;
        int i2 = 0;
        while (i2 < this.menuOptions.length) {
            if (i2 != selectedOptionIndex) {
                graphics.setColor(Color.text);
                graphics.drawString(this.menuOptions[i2], menuOptionX, menuOptionY, 20);
            } else {
                graphics.setColor(Color.selectBg);
                int highOptionY = this.height - this.menuHeight - sub_margin_bottom - this.submenuMaxHeight + i2 * (fontHeight + this.padding) - sub_padding;
                graphics.fillRect(sub_margin_left + sub_padding, highOptionY, this.submenuMaxWidth + 1, fontHeight + this.padding);
                graphics.setColor(Color.selectText);
                graphics.drawString(this.menuOptions[i2], menuOptionX, menuOptionY, 20);
            }
            menuOptionY += this.padding + fontHeight;
            ++i2;
        }
    }

    public void drawInactiveMenu(GameCanvas canvas, Graphics graphics) {
        this.drawMenu(canvas, graphics, this.leftOption, this.rightOption);
    }

    public void drawActiveMenu(GameCanvas canvas, Graphics graphics, int selectedOptionIndex) {
        this.drawMenu(canvas, graphics, this.cancelOption, this.okOption);
        if (this.menuOptions != null) {
            this.drawSubMenu(graphics, selectedOptionIndex);
        }
    }

    public void eventMenu(int id) {
    }

    public int touchMenu(int x, int y) {
        int yes = -1;
        this.padding = 5;
        if (this.isActive) {
            if (x > this.padding && x < this.menuHeight * 2 + this.padding && y > this.height - this.menuHeight) {
                this.isActive = false;
            }
            if (x > this.width - this.menuHeight * 2 - this.padding && x < this.width && y > this.height - this.menuHeight) {
                this.isActive = false;
            }
            int menuOptionY = this.height - this.menuHeight - this.submenuMaxHeight;
            int i = 0;
            while (i < this.menuOptions.length) {
                if (x > this.padding && x < this.submenuMaxWidth && y > menuOptionY) {
                    if (y > menuOptionY + i * this.submenuMaxHeight / this.menuOptions.length && y < menuOptionY + (i + 1) * this.submenuMaxHeight / this.menuOptions.length) {
                        if (this.select == i) {
                            this.isActive = false;
                            yes = i;
                        } else {
                            this.select = i;
                        }
                    }
                } else {
                    this.isActive = false;
                }
                ++i;
            }
        } else if (x > this.padding && x < this.menuHeight * 2 + this.padding && y > this.height - this.menuHeight) {
            this.isActive = true;
        }
        return yes;
    }
}

