/*
 * Decompiled with CFR 0.152.
 */
package view;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import until.Color;
import view.ListItem;

public class ListView {
    public ListItem[] listData;
    public int length = 0;
    private Font ft;
    private int padding;
    private int width;
    private int height;
    public int itemHeight;
    public int select = 0;

    public ListView(GameCanvas canvas) {
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
        this.listData = new ListItem[1];
    }

    public void ClearAll() {
        this.select = 0;
        this.length = 0;
    }

    public ListItem GetItem(int i) {
        if (i < this.length) {
            return this.listData[i];
        }
        return null;
    }

    public void AddItem(String title, String subtitle, String url) {
        ListItem[] newList = new ListItem[this.length + 1];
        int i = 0;
        while (i < this.length + 1) {
            newList[i] = new ListItem(title, subtitle, url);
            ++i;
        }
        i = 0;
        while (i < this.length) {
            newList[i + 1].title = this.listData[i].title;
            newList[i + 1].subtitle = this.listData[i].subtitle;
            newList[i + 1].url = this.listData[i].url;
            ++i;
        }
        this.listData = newList;
        ++this.length;
    }

    public void DrawList(Graphics graphics, int selectedIndex) {
        this.padding = 5;
        this.ft = Font.getFont((int)64, (int)1, (int)0);
        int fontHeight = this.ft.getHeight();
        this.itemHeight = fontHeight * 2 + 3 * this.padding;
        int i = 0;
        while (i < this.length) {
            int y = 0;
            int yy = this.itemHeight * selectedIndex + fontHeight * 2 + this.padding * 2;
            if (yy > this.height) {
                y = this.height - yy - this.itemHeight;
            }
            if (i != selectedIndex) {
                graphics.setColor(Color.text);
                graphics.drawString(this.listData[i].title, this.padding, this.itemHeight * i + this.padding + y, 20);
                graphics.setColor(0xBBBBBB);
                graphics.drawString(this.listData[i].subtitle, this.padding, this.itemHeight * i + fontHeight + this.padding * 2 + y, 20);
            } else {
                graphics.setColor(Color.selectBg);
                graphics.fillRect(0, this.itemHeight * i + y, this.width, this.itemHeight);
                graphics.setColor(Color.strong);
                graphics.drawString(this.listData[i].title, this.padding, this.itemHeight * i + this.padding + y, 20);
                graphics.setColor(0xBBBBBB);
                graphics.drawString(this.listData[i].subtitle, this.padding, this.itemHeight * i + fontHeight + this.padding * 2 + y, 20);
            }
            ++i;
        }
    }
}

